﻿# -*- coding: utf-8 -*-
from ppms import ppms
from ppms.migration import SQLPacket, PacketCategory, VersionType, MaxVersionDependency


class PortExportSchedulingDataCustomizing(SQLPacket):
    '''Port customizing for anonymized scheduling data export'''
    version = 1
    done_after_success = True
    run_on_startup = False
    category = PacketCategory.CATEGORY_OPTIONAL
    wi_number = 14989
    
    def get_dependencies(self):
        return (MaxVersionDependency(version='39.5.6', version_type=VersionType.CUSTOMIZING), )

    def fix(self, runner):
        if ppms.db_get_dbms_name() == '000002':
            if not ppms.db_select("""SELECT nullable
  FROM all_tab_cols
 WHERE table_name = 'DT405'
   AND column_name = 'DI000912'""") and not ppms.db_select("""SELECT nullable
  FROM all_tab_cols
 WHERE table_name = 'DT515'
   AND column_name = 'DI027460'"""):
                ppms.db_modify("ALTER TABLE DT405 MODIFY (DI000912 NULL)")
                ppms.db_modify("ALTER TABLE DT515 MODIFY (DI027460 NULL)")
        elif ppms.db_get_dbms_name() == '000004':
            if not ppms.db_select("""select  is_nullable 
from    sys.columns 
where   object_id = object_id('DT405') 
        and name = 'DI000912'""") and not ppms.db_select("""select  is_nullable 
from    sys.columns 
where   object_id = object_id('DT515') 
        and name = 'DI027460'"""):
                ppms.db_modify("ALTER TABLE DT405 ALTER COLUMN DI000912 VARCHAR(8) NULL")
                ppms.db_modify("ALTER TABLE DT515 ALTER COLUMN DI027460 VARCHAR(16) NULL")

        self.apply_dml_file(self.sql_planta_de_dbms, "WI14989_port_export_scheduling_data_customizing.sql")

        if not ppms.db_select("SELECT COUNT(*) FROM DT405 WHERE DI000123 = '009CF2'"):
            self.apply_dml_file(self.sql_planta_de_dbms, "WI14989_port_method_of_module_subclass_macro.sql")

        return self.success()