﻿# -*- coding: utf-8 -*-
from ppms import ppms
from ppms.migration import SQLPacket, PacketCategory, VersionType, MaxVersionDependency


class PortExportSchedulingDataCustomizing(SQLPacket):
    '''Port customizing for anonymized scheduling data export'''
    version = 1
    done_after_success = True
    run_on_startup = False
    category = PacketCategory.CATEGORY_OPTIONAL
    wi_number = 14989
    
    def get_dependencies(self):
        return (MaxVersionDependency(version='39.5.6', version_type=VersionType.CUSTOMIZING), )

    def fix(self, runner):
        if ppms.db_get_dbms_name() == '000002':
            if not ppms.db_select("""SELECT nullable
  FROM all_tab_cols
 WHERE table_name = 'DT405'
   AND column_name = 'DI000912'""") and not ppms.db_select("""SELECT nullable
  FROM all_tab_cols
 WHERE table_name = 'DT515'
   AND column_name = 'DI027460'"""):
                ppms.db_modify("ALTER TABLE DT405 MODIFY (DI000912 NULL)")
                ppms.db_modify("ALTER TABLE DT515 MODIFY (DI027460 NULL)")
            if not ppms.db_select("SELECT * FROM DT412 WHERE DI000238 = '059754'"):
                ppms.db_modify("""Insert into DT412
                (DI000238,DI000239,DI000252,DI003141,DI000407,DI000408,DI001866,DI001867,DI001868,DI001869,DI000548,DI001870,DI001871,DI001872,DI000241,DI000242,DI000274,DI000244,DI004316,DI004332,DI010594,DI000246,DI000247,DI000248,DI011526,DI011527,DI000251,DI001700,DI001701,DI000253,DI000254,DI011528,DI001257,DI022956,DI001591,DI001437,DI001469,DI000275,DI001165,DI003036,DI003037,DI000967,DI001990,DI000257,DI000215,DI011529,DI011530,DI011531,DI002461,DI003685,DI007566,DI007571,DI009470,DI026600,DI026799,DI027352,DI026678,DI026679,DI027171,DI027172,DI027252,DI027253,DI027317,DI027328,DI027356,DI027386,DI027492,DI027567,DI028158,DI028159,DI028175,DI028192,DI040134,DI040835,DI040836,DI040837,DI041035,DI041246)
                values 
                ('059754','400','-','AL',to_date('13.04.11','DD.MM.RR'),to_date('13.04.11','DD.MM.RR'),'7','MAGR','MAGR','011',null,'7','7','7','0','0','0','AL',null,null,'0','40','0','0',null,null,null,'0',null,'X','40',null,'0',null,'740978',null,'1','1','2',null,to_date('13.04.11','DD.MM.RR'),'1',null,null,null,null,null,null,'0',null,null,null,null,'-',null, EMPTY_CLOB(),'0','0','0','0',null,null,null,null,'0','0',null,null,'0','0','0',null,null,null,null,null,'object','5')""")
        elif ppms.db_get_dbms_name() == '000004':
            if not ppms.db_select("""select  is_nullable 
from    sys.columns 
where   object_id = object_id('DT405') 
        and name = 'DI000912'""") and not ppms.db_select("""select  is_nullable 
from    sys.columns 
where   object_id = object_id('DT515') 
        and name = 'DI027460'"""):
                ppms.db_modify("ALTER TABLE DT405 ALTER COLUMN DI000912 VARCHAR(8) NULL")
                ppms.db_modify("ALTER TABLE DT515 ALTER COLUMN DI027460 VARCHAR(16) NULL")
            if not ppms.db_select("SELECT * FROM DT412 WHERE DI000238 = '059754'"):
                ppms.db_modify("""Insert into DT412
                (DI000238,DI000239,DI000252,DI003141,DI000407,DI000408,DI001866,DI001867,DI001868,DI001869,DI000548,DI001870,DI001871,DI001872,DI000241,DI000242,DI000274,DI000244,DI004316,DI004332,DI010594,DI000246,DI000247,DI000248,DI011526,DI011527,DI000251,DI001700,DI001701,DI000253,DI000254,DI011528,DI001257,DI022956,DI001591,DI001437,DI001469,DI000275,DI001165,DI003036,DI003037,DI000967,DI001990,DI000257,DI000215,DI011529,DI011530,DI011531,DI002461,DI003685,DI007566,DI007571,DI009470,DI026600,DI026799,DI027352,DI026678,DI026679,DI027171,DI027172,DI027252,DI027253,DI027317,DI027328,DI027356,DI027386,DI027492,DI027567,DI028158,DI028159,DI028175,DI028192,DI040134,DI040835,DI040836,DI040837,DI041035,DI041246)
                values 
                ('059754','400','-','AL',convert(datetime,'13.04.11',4),convert(datetime,'13.04.11',4),'7','MAGR','MAGR','011',null,'7','7','7','0','0','0','AL',null,null,'0','40','0','0',null,null,null,'0',null,'X','40',null,'0',null,'740978',null,'1','1','2',null,convert(datetime,'13.04.11',4),'1',null,null,null,null,null,null,'0',null,null,null,null,'-',null, EMPTY_CLOB(),'0','0','0','0',null,null,null,null,'0','0',null,null,'0','0','0',null,null,null,null,null,'object','5')""")

        self.apply_dml_file(self.sql_planta_de_dbms, "WI14989_port_export_scheduling_data_customizing.sql")

        if not ppms.db_select("SELECT COUNT(*) FROM DT405 WHERE DI000123 = '009CF2'"):
            self.apply_dml_file(self.sql_planta_de_dbms, "WI14989_port_method_of_module_subclass_macro.sql")

        return self.success()